<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_FGO_Premium_Order {


    public static function buildFactura($order_id){
        $order = new WC_Order($order_id);
        $order_data = $order->get_data();
        $key = "4C490B5C";

        $current_user = wp_get_current_user();
        $current_user_id = $current_user->ID;
        $current_user_role = $current_user->roles[0];

        $send_series = get_option('wc_settings_tab_fgo_series_option');
       
        if($send_series == '0'){
            $invoice_series = get_option('wc_settings_tab_fgo_invoice_series');
        }
        else if($send_series == '1'){
            $invoice_series = get_option('wc_settings_tab_fgo_invoice_series_'.$current_user_role.'');
        }

        $order_billing_first_name = $order_data['billing']['first_name'];
        $order_billing_last_name = $order_data['billing']['last_name'];
        $order_billing_company = $order_data['billing']['company'];
        $order_billing_checkbox_cui =  $order_data['billing']['billing_checkbox_trigger'];

        $order_billing_address_1 = $order_data['billing']['address_1'];

        $codUnic = get_option('wc_settings_tab_fgo_client_code');
        $privateKey = get_option('wc_settings_tab_fgo_private_key');
        $denumire = $order_billing_company;
        $order_billing_tip_client = 'PJ';
        if (empty($denumire))
        {
            $denumire = $order_billing_first_name . ' ' . $order_billing_last_name;
            $order_billing_tip_client = 'PF';
        }
        if (!empty($invoice_series))
        {
            $data['Serie'] = $invoice_series;
        }
        $data['CodUnic'] = $codUnic;
        $data['Hash'] = strtoupper(SHA1($codUnic . $privateKey . CONFIG::convertDiacritics2($denumire)));
       
        if (get_option('wc_settings_tab_fgo_invoice_type') == 'notice')
            $data['TipFactura'] = CONFIG::$FGO_TIP_AVIZ;
        else if (get_option('wc_settings_tab_fgo_invoice_type') == 'order')
            $data['TipFactura'] = CONFIG::$FGO_TIP_PROFORMA;
        else
            $data['TipFactura'] = CONFIG::$FGO_TIP_FACTURA;

        if(get_option('wc_settings_tab_fgo_check_duplicates') == '0')
            $data['VerificareDuplicat'] = 'false';
        else
            $data['VerificareDuplicat'] = 'true';

        $data['Valuta'] = get_option('woocommerce_currency');//CONFIG::$FGO_VALUTA;
       // if(strtoupper($data['Valuta']) == 'RON')
         //   $data['Valuta'] = 'LEU';
        $data['Client[Denumire]'] = CONFIG::convertDiacritics2($denumire);
        $data['Client[CodUnic]'] = '';
        $data['Client[Tip]'] = $order_billing_tip_client;
        $data['Client[IdExtern]'] = $order_data['customer_id'];

        if( $data['Client[Tip]'] == 'PJ'){
            if (get_option('wc_settings_tab_fgo_client_vat') == '1'){
                $vat = '';
              
                $vat = get_post_meta( $order_id, 'woocommerce_fgo_billing_cui', true );
                $vat_numeric = $vat;
                if(!is_int($vat)){
                    $vat_numeric = strtoupper($vat);
                    if(strpos($vat_numeric, 'RO') === 0){
                        $vat_numeric = trim(substr($vat_numeric, 2));
                    }
                    if(strpos($vat_numeric, '0') === 0){
                        $vat_numeric = trim(substr($vat_numeric, 1));
                    }
                }
                $data['Client[CodUnic]'] = $vat;
                $data['Client[NrRegCom]'] = get_post_meta( $order_id, 'woocommerce_fgo_billing_reg', true );
                $data['Client[IdExtern]'] =  $vat_numeric;
            }
        }

        if (get_option('wc_settings_tab_fgo_client_vat_sanitize') == '1')
        {
            $data['ValideazaCodUnicRo'] = 'true';
        }
       
        $data['Client[Email]'] = $order_data['billing']['email'];
        $data['Client[Telefon]'] = $order_data['billing']['phone'];
        $data['Client[Tara]'] = $order_data['billing']['country']; //WC()->countries->countries[ $order_data['billing']['country'] ];

        if($data['Client[Tara]'] != null && $data['Client[Tara]'] != 'RO')
            $data['Client[Strain]'] = "true";

        $data['Client[Judet]'] = $order->get_billing_state();
        $data['Client[Localitate]'] = $order->get_billing_city();
        $data['Client[Adresa]'] =  formatted_billing_address($order);
       
        $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
        $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
        $data['Versiune'] = WC()->version;
        $data['VersiuneAddon'] = CONFIG::$FGO_VERSIUNE_MODUL;
        $data['Continut'] = array();
        $data['IdExtern'] = $order_id;
        $data['Token'] = strtoupper(SHA1($order_id . $data['Client[IdExtern]'] . $key));
        if (get_option('wc_settings_tab_fgo_insert_cc') == '1')
        {
            $data['Text'] = 'Note: ' . $order->customer_message;
        }

        $payment =  '';
        if(!empty($order->get_payment_method_title())){
            $payment = strip_tags($order->get_payment_method_title());
        }

        $descSettings = serialize(get_option('wc_settings_tab_fgo_desc_items'));
        $data['Explicatii'] = '';

        if(strpos($descSettings, CONFIG::$FGO_DESC_ORDERID) != false){
            $data['Explicatii'] = $data['Explicatii'] . 'Comanda nr. ' . $order_id . '|' ;
        }
        if(strpos($descSettings, CONFIG::$FGO_DESC_PAYMENT) != false){
            $data['Explicatii'] = $data['Explicatii'] . 'Modalitate plata: ' . $payment . '  |';
        }
        if(strpos($descSettings,  CONFIG::$FGO_DESC_SHIPPING ) != false){
            $data['Explicatii'] = $data['Explicatii'] . ' Modalitate livrare: ' . $order->get_shipping_method();
        }

        $tva = 0;

        foreach ($order->get_items() as $item_id => $item_obj) {
            $item_data = $item_obj->get_data();
            
            $item = array();
            $item['Denumire'] = strip_tags($item_data['name']);
            
           // $a = WC_Tax::get_rates( $item_obj->get_tax_class());
        //    $tax_rates = WC_Tax::get_rates( $item_obj->get_tax_class() );
        //    if (!empty($tax_rates)) {
        //        $tax_rate = reset($tax_rates);
        //     }

           
        //     if($tax_rate['rate'] != null)
        //         $tva = $tax_rate['rate'];
            
            $item['NrProduse'] = $item_data['quantity'];
            
            $product = $item_obj->get_product();	
           
            if (get_option('wc_settings_tab_fgo_product_mapping') == '1')
            {
                $item['CodArticol'] = $product->get_sku();

                if(get_option('wc_settings_tab_fgo_product_description') == 1){
                    $item['Descriere'] = "Cod SKU: " .  $item['CodArticol'];
                }
            }              					
            
           // $item['Descriere'] = '[[descriere]]'.' Cod SKU: '.$product->get_sku();

           // if (is_nan($tva)) $tva = 0;

            // if (strpos($tva, '.') !== false)
            //     {
            //         $tva = substr($tva, 0, strpos($tva, '.'));
            //     }
            
            // $item['CotaTVA'] =  $tva;
           
            $pretDeBaza = $product->get_regular_price(); //pretul de baza, in cazul in care exista si pret special pe articol
            $pretCart =  $item_data['subtotal'] +  $item_data['subtotal_tax']; //pretul din pagina de comanda
            
            //verificare bifa
            if(get_option('wc_settings_tab_fgo_discount_invoice') == '1' && $pretCart / $item_data['quantity'] < $pretDeBaza){
            $item['PretTotal'] = $pretDeBaza * $item_data['quantity'];
            }
            else{
            $item['PretTotal'] =  $pretCart;
            }

            if($item['PretTotal'] < 0.00){
                $item['PretTotal'] = abs($item['PretTotal']);
                $item['NrProduse'] = -1 *  $item_data['quantity'];
            }
           
            $tva = round(((($item_data['subtotal'] + $item_data['subtotal_tax']) / $item_data['subtotal'])-1)*100);
			if (is_nan($tva)) $tva = 0;
            $item['CotaTVA'] = $tva;

            $item['UM'] = CONFIG::$FGO_UM;
            $codGestiune = get_option('wc_settings_tab_fgo_product_management') != null ? get_option('wc_settings_tab_fgo_product_management') : null;
            $item['CodGestiune'] = $codGestiune;
            array_push($data['Continut'], $item);

            if(get_option('wc_settings_tab_fgo_discount_invoice') == '1' && $pretDeBaza != null && $pretCart / $item_data['quantity'] < $pretDeBaza){
               $valoareReducere = number_format($pretDeBaza * $item_data['quantity'] - $pretCart, 2 , '.', ''); //pretCart = e pretul total (pret produs * nrProduse); pretDeBaza este pretul produsului
               
               if($valoareReducere > 0.00){
                $codArticolReducereArticol = get_option('wc_settings_tab_fgo_discount_mapping') != null ? get_option('wc_settings_tab_fgo_discount_mapping') : null;

                array_push($data['Continut'], array(
                    'Denumire' => 'Reducere '.$item['Denumire'],
                    'CodArticol' => $codArticolReducereArticol,
                    'PretTotal' => $valoareReducere, 
                    'UM' => 'buc',
                    'NrProduse' => - 1 * $item_data['quantity'],
                    'CotaTVA' => $tva,
                    'CodGestiune' => $codGestiune
                ));
                }
            }

        }  

        // Get order total discount
        $order_discount_total = $order->get_discount_total() + $order->get_discount_tax() ;
        if ($order_discount_total > 0)
        {
            $codArticolReducere = get_option('wc_settings_tab_fgo_discount_mapping') != null ? get_option('wc_settings_tab_fgo_discount_mapping') : null;
            // Get the correct number format (2 decimals) modificat - se calculeaza cu 2 zecimale
            $order_discount_total = number_format( $order_discount_total, 2 , '.', '');

            array_push($data['Continut'], array(
                    'Denumire' => 'Reducere',
                    'CodArticol' => $codArticolReducere,
                    'PretTotal' => $order_discount_total,
                    'UM' => 'buc',
                    'NrProduse' => -1,
                    'CotaTVA' => $tva,
                    'CodGestiune' => $codGestiune
                ));
        }	
        
        foreach( $order->get_items('fee') as $item_id => $item_fee ){

            // The fee name
            $fee_name = $item_fee->get_name();
        
            // The fee total amount
            $fee_total = $item_fee->get_total();
        
            // The fee total tax amount
            $fee_total_tax = $item_fee->get_total_tax();

            $fee_subtotal = $fee_total -  $fee_total_tax;

            // Get the correct number format (2 decimals) modificat - se calculeaza cu 2 zecimale
            $fee_total = number_format( $fee_total, 2 , '.', '');

            $fee_vat  = round(((($fee_total + $fee_total_tax) / $fee_total)-1)*100);

            $nrTax = 1;
            if($fee_total < 0.00)
            {
                $fee_total = abs($fee_total);
                $nrTax = -1;
            }

            array_push($data['Continut'], array(
                    'Denumire' => $fee_name,
                    'PretTotal' => $fee_total + $fee_total_tax,
                    'UM' => 'buc',
                    'NrProduse' => $nrTax,
                    'CotaTVA' => $fee_vat,
                    'CodGestiune' => $codGestiune
                ));
        }

        if (get_option('wc_settings_tab_fgo_insert_shipping') == '1')
        {
            $codGestiuneLivrare = get_option('wc_settings_tab_fgo_product_management') != null ? get_option('wc_settings_tab_fgo_product_management') : null;
            $codArticolLivrare = get_option('wc_settings_tab_fgo_shipping_mapping') != null ? get_option('wc_settings_tab_fgo_shipping_mapping') : null;
            $shipping = $order->get_shipping_total();
            if ($shipping > 0)
            {
                $tva = 0;
                
                if (get_option('wc_settings_tab_fgo_shipping_vat') == '1')
                {	
                    $tva = 19;
                }

                $tipPret = "PretTotal";

                if(get_option('wc_settings_tab_fgo_shipping_vat_type') == 0)
                    $tipPret = "PretUnitar";

                if(get_option('wc_settings_tab_fgo_product_management_shipping') != null)
                    $codGestiuneLivrare = get_option('wc_settings_tab_fgo_product_management_shipping');    

                array_push($data['Continut'], array(
                    'Denumire' => 'Cost transport',
                    'CodArticol' => $codArticolLivrare,
                    $tipPret => number_format((float)$shipping, 2, '.', ''),
                    'UM' => 'buc',
                    'NrProduse' => 1,
                    'CotaTVA' => $tva,
                    'CodGestiune' => $codGestiuneLivrare
                ));
            }
        }

        $refound_amount = $order->get_total_refunded();
            if ($refound_amount <> 0)
            {
                $codGestiune = get_option('wc_settings_tab_fgo_product_management') != null ? get_option('wc_settings_tab_fgo_product_management') : null;
                $motiv = 'Rambursare';							

                array_push($data['Continut'], array(
                    'Denumire' => $motiv,
                    'PretTotal' => abs($refound_amount),
                    'UM' => 'buc',
                    'NrProduse' => -1,
                    'CotaTVA' => $tva,
                    'CodGestiune' => $codGestiune
                ));
            }

        $options = array(
            'http' => array(
                'header'  => "Content-type: application/x-www-form-urlencoded;charset=UTF-8",						
                'method'  => 'POST',
                'content' => http_build_query($data),
                'ignore_errors' => true
            )
        );
        $root = CONFIG::$FGO_SANDBOX_ROOT;
        if (get_option('wc_settings_tab_fgo_sandbox') == '0') {
            $root = CONFIG::$FGO_ROOT;
        }
        $url = $root . 'factura/emitere';
        $data = array();
        $context  = stream_context_create($options);
        
        $result = file_get_contents($url, false, $context);
        $response = json_decode($result);

        if ($response->{'Success'})
        {
            update_post_meta( $order_id, '_fgo_invoice_link', $response->{'Factura'}->{'Link'} );
            update_post_meta( $order_id, '_fgo_invoice_number', $response->{'Factura'}->{'Numar'});
            update_post_meta( $order_id, '_fgo_invoice_series', $response->{'Factura'}->{'Serie'});
            update_post_meta( $order_id, '_fgo_invoice_payment', $response->{'Factura'}->{'LinkPlata'});
            update_post_meta( $_POST['post_id'], '_fgo_invoice_status', 'emisa' );   
            if(get_option('wc_settings_tab_fgo_stock_management') == '1')   
                WC_FGO_Premium_Order::updateStockAfterInvoice($order);	              
        }
        else {
            //update_post_meta( $order_id, '_fgo_invoice_link', '' );
            // update_post_meta( $order_id, '_fgo_invoice_number', '');
            // update_post_meta( $order_id, '_fgo_invoice_series', '');
        }
        //echo $response->{'Factura'}->{'Link'};
        update_option('wc_settings_tab_fgo_last_api_call',date('Y-m-d H:i:s.u'));
        return $result;
        exit;
    }

    public static function init() {
        // Adding Meta container admin shop_order pages
		add_action( 'add_meta_boxes', 'mv_add_meta_boxes' );
		if ( ! function_exists( 'mv_add_meta_boxes' ) )
		{
			function mv_add_meta_boxes()
			{
                wp_enqueue_script( 'fgo-script', plugin_dir_url( __FILE__ ) . 'assets/js/fgo-premium-order.js', array ( 'jquery' ), 1.1, true);
				add_meta_box( 'woocommerce-fgo-premium', __('FGO','woocommerce'), 'mv_add_other_fields_for_fgo', array('shop_order','order_view'), 'side', 'core' );
			}
		}
		// Adding Meta field in the meta container admin shop_order pages
		if ( ! function_exists( 'mv_add_other_fields_for_fgo' ) )
		{
			function mv_add_other_fields_for_fgo()
			{
				global $post;

                $params = array(
                 'ajax_url' => admin_url('admin-ajax.php', 'woocommerce_admin_meta_boxes_fgo_premium'),
                 'ajax_nonce' => wp_create_nonce('fgo_field_nonce'),
                 'post_id' => $post->ID
               );
                wp_localize_script( 'fgo-script', 'woocommerce_admin_meta_boxes_fgo_premium', $params );

				$meta_invoice_link = get_post_meta( $post->ID, '_fgo_invoice_link', true ) ? get_post_meta( $post->ID, '_fgo_invoice_link', true ) : '';
				$meta_invoice_number = get_post_meta( $post->ID, '_fgo_invoice_number', true ) ? get_post_meta( $post->ID, '_fgo_invoice_number', true ) : '';
                $meta_invoice_series = get_post_meta( $post->ID, '_fgo_invoice_series', true ) ? get_post_meta( $post->ID, '_fgo_invoice_series', true ) : '';
                $meta_invoice_status = get_post_meta( $post->ID, '_fgo_invoice_status', true ) ? get_post_meta( $post->ID, '_fgo_invoice_status', true ) : '';				
                $meta_invoice_payment = get_post_meta( $post->ID, '_fgo_invoice_payment', true ) ? get_post_meta( $post->ID, '_fgo_invoice_payment', true ) : '';
                $meta_invoice_awb = get_post_meta($post->ID, '_fgo_invoice_awb', true) ? get_post_meta($post->ID, '_fgo_invoice_awb', true)	: '';		

                // to do delete
                //$meta_invoice_link = '';
               
                $fgo_is_working = get_option('wc_settings_tab_fgo_is_working');

                if($fgo_is_working == '' || $fgo_is_working  == '0'){
                    echo '<p><b><font color="red">Asigura-te ca ai configurat corect setarile FGO! Intra in Woocommerce->setari->fgo si salveaza din nou setarile!</font></b></p>';
                }
                else if (empty($meta_invoice_link))
				{
                    //<input type="hidden" name="fgo_field_nonce_2" id="fgo_field_nonce-2" value="' . wp_create_nonce() . '">
				    if ($meta_invoice_status == 'anulata')
                    {
                        echo '<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>Factura a fost anulata</p></div></li></ul>';
                    }
                    else if ($meta_invoice_status == 'stornata')
                    {
                        echo '<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>Factura a fost stornata</p></div></li></ul>';
                    }
                    else {
                        echo '<p style="border-bottom:solid 1px #eee;padding-bottom:13px;text-align:center;">
                                <button type="button" class="fgo_create_invoice button">Genereaza Factura</button>
                            </p>';
                    }
				}
				else
				{
                   
					echo '<p style="border-bottom:solid 1px #eee;padding-bottom:13px;text-align:center;">
                            <a href="' . $meta_invoice_link . '" target="_blank" class="button">Vizualizare Factura ' . $meta_invoice_series . $meta_invoice_number . '</a> <br>
                            <a href="#" class="fgo_cancel_invoice">Anuleaza Factura</a> &nbsp;&nbsp; <a href="#" class="fgo_delete_invoice">Sterge Factura</a>
                            &nbsp;&nbsp; <a href="#" class="fgo_storno_invoice">Storneaza Factura</a>
                          </p>';

                    if(!empty($meta_invoice_payment)){
                        echo'<p>Link plata:
                        <input type="text" disabled value="' . $meta_invoice_payment . '"><br>
                        </p>';
                    }
                        echo'<p>AWB: <span class="fgo_awb_existent">' . $meta_invoice_awb . '</span><a href="#" class="fgo_awb"> Adauga/Modifica AWB</a></p>';
				}
			}
		}

        add_action('wp_ajax_woocommerce_fgo_create_invoice', 'woocommerce_fgo_create_invoice');
        add_action('wp_ajax_nopriv_woocommerce_fgo_create_invoice', 'woocommerce_fgo_create_invoice');
        if ( ! function_exists( 'woocommerce_fgo_create_invoice' ) )
        {
            WC_FGO_Premium_Order::createInvoice();
        }

        add_action('wp_ajax_woocommerce_fgo_cancel_invoice', 'woocommerce_fgo_cancel_invoice');
        add_action('wp_ajax_nopriv_woocommerce_fgo_cancel_invoice', 'woocommerce_fgo_cancel_invoice');
        if ( ! function_exists( 'woocommerce_fgo_cancel_invoice' ) )
        {
            WC_FGO_Premium_Order::cancelInvoice();
        }

		add_action('wp_ajax_woocommerce_fgo_delete_invoice', 'woocommerce_fgo_delete_invoice');
        add_action('wp_ajax_nopriv_woocommerce_fgo_delete_invoice', 'woocommerce_fgo_delete_invoice');
        if ( ! function_exists( 'woocommerce_fgo_delete_invoice' ) )
        {
            WC_FGO_Premium_Order::deleteInvoice();
        }

        add_action('wp_ajax_woocommerce_fgo_storno_invoice', 'woocommerce_fgo_storno_invoice');
        add_action('wp_ajax_nopriv_woocommerce_fgo_storno_invoice', 'woocommerce_fgo_storno_invoice');
        if ( ! function_exists( 'woocommerce_fgo_storno_invoice' ) )
        {
            WC_FGO_Premium_Order::stornoInvoice();
        }

        add_action('wp_ajax_woocommerce_fgo_add_awb', 'woocommerce_fgo_add_awb');
        add_action('wp_ajax_nopriv_woocommerce_fgo_add_awb', 'woocommerce_fgo_add_awb');
        if ( ! function_exists( 'woocommerce_fgo_add_awb' ) )
        {
            WC_FGO_Premium_Order::addAWB();
        }

     //   add_action( 'woocommerce_thankyou', 'OnPlacedOrder' );
      //  add_action( 'wp_ajax_nopriv_woocommerce_thankyou', 'OnPlacedOrder' );
        add_action( 'woocommerce_order_status_processing', 'fgo_woocommerce_order_status_processing' );

        function fgo_woocommerce_order_status_processing( $order_id ) {
            // Get an instance of the WC_Order Object
            $order = wc_get_order( $order_id );
        
            if( !in_array( $order->get_status(), ['failed'] ) ) {
                $fgo_is_working = get_option('wc_settings_tab_fgo_is_working');
                if ($fgo_is_working != '' && $fgo_is_working == 1 && get_option('wc_settings_tab_fgo_api_call') == 'onOrder'){
                    if (!get_post_meta($order_id, '_fgo_invoice_link', true )){
                        $lastApiCall = get_option('wc_settings_tab_fgo_last_api_call');

                        if($lastApiCall != null && strtotime(date('Y-m-d H:i:s.u')) - strtotime($lastApiCall) < 1)
                        {
                            sleep(1);
                        }

                        WC_FGO_Premium_Order::buildFactura($order_id);
                    }
                }
            }
        }

        add_action( 'woocommerce_order_status_completed', 'fgo_woocommerce_order_status_completed' );

        function fgo_woocommerce_order_status_completed($order_id){
             // Get an instance of the WC_Order Object
             $order = wc_get_order( $order_id );
        
             if( !in_array( $order->get_status(), ['failed','pending'] ) ) {
                 $fgo_is_working = get_option('wc_settings_tab_fgo_is_working');
                 if ($fgo_is_working != '' && $fgo_is_working == 1 && get_option('wc_settings_tab_fgo_api_call') == 'onCompleted'){
                     if (!get_post_meta($order_id, '_fgo_invoice_link', true )){
                       
                        $lastApiCall = get_option('wc_settings_tab_fgo_last_api_call');

                        if($lastApiCall != null && strtotime(date('Y-m-d H:i:s.u')) - strtotime($lastApiCall) < 1)
                        {
                            sleep(1);
                        }
                        
                        WC_FGO_Premium_Order::buildFactura($order_id);
                    }
                }
            }
        }

        add_action( 'woocommerce_payment_complete', 'fgo_woocommerce_payment_complete' );

        function fgo_woocommerce_payment_complete($order_id){
             // Get an instance of the WC_Order Object
             $order = wc_get_order( $order_id );
        
             if( !in_array( $order->get_status(), ['failed','pending'] ) ) {
                 $fgo_is_working = get_option('wc_settings_tab_fgo_is_working');
                 if ($fgo_is_working != '' && $fgo_is_working == 1 && get_option('wc_settings_tab_fgo_api_call') == 'onPayment'){
                     if (!get_post_meta($order_id, '_fgo_invoice_link', true )){

                        $lastApiCall = get_option('wc_settings_tab_fgo_last_api_call');

                        if($lastApiCall != null && strtotime(date('Y-m-d H:i:s.u')) - strtotime($lastApiCall) < 1)
                        {
                            sleep(1);
                        }

                         WC_FGO_Premium_Order::buildFactura($order_id);
                    }
                }
            }
        }
    }

    public static function createInvoice(){	
		/*function custom_content_thankyou( $order_id ) {
			woocommerce_fgo_create_invoice($order_id );
		}	*/	
        function woocommerce_fgo_create_invoice()
        {
            if (check_ajax_referer( 'fgo_field_nonce', 'security' ))
            {                							
                $order_id = $_POST['post_id'];
                
                $lastApiCall = get_option('wc_settings_tab_fgo_last_api_call');

                if($lastApiCall != null && strtotime(date('Y-m-d H:i:s.u')) - strtotime($lastApiCall) < 1)
                {
                    sleep(1);
                }

                $result = WC_FGO_Premium_Order::buildFactura($order_id);	
                echo $result;	
                
                exit;
           }
        }

        function formatted_billing_address($order)
        {
            return
                $order->get_billing_address_1() . ', ' .
                $order->get_billing_address_2() . ' ' .
                $order->get_billing_state()  . ' ' .
                $order->get_billing_postcode();
        }
    }

    public static function cancelInvoice(){
        function woocommerce_fgo_cancel_invoice()
        {
            if (check_ajax_referer( 'fgo_field_nonce', 'security' ))
            {
                $root = CONFIG::$FGO_SANDBOX_ROOT;
                $key = "4C490B5C";
                if (get_option('wc_settings_tab_fgo_sandbox') == '0') {
                    $root = CONFIG::$FGO_ROOT;
                }
                $url = $root . 'factura/anulare';
                $data = array();

                $codUnic = get_option('wc_settings_tab_fgo_client_code');
                $privateKey = get_option('wc_settings_tab_fgo_private_key');
                $meta_invoice_number = get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) : '';
                $meta_invoice_series = get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) : '';

                $data['CodUnic'] = $codUnic;
                $data['Hash'] = strtoupper(SHA1($codUnic . $privateKey . $meta_invoice_number));
                $data['Serie'] = $meta_invoice_series;
                $data['Numar'] = $meta_invoice_number;
                $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
                $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
                $data['Versiune'] = WC()->version;
                $data['VersiuneAddon'] = CONFIG::$FGO_VERSIUNE_MODUL;
                $token = strtoupper(SHA1( $meta_invoice_series . $meta_invoice_number . $key));
                $data['Token'] = $token;

                $options = array(
                    'http' => array(
                        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                        'method'  => 'POST',
                        'content' => http_build_query($data)
                    )
                );
                $context  = stream_context_create($options);
                $result = file_get_contents($url, false, $context);
                $response = json_decode($result);

                if ($response->{'Success'})
                {
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_status', 'anulata' );
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_link', '' );
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_number', '');
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_series', '');
                }
              //  echo $result;
                exit;
            }
        }
    }

	public static function deleteInvoice(){
        function woocommerce_fgo_delete_invoice()
        {
            if (check_ajax_referer( 'fgo_field_nonce', 'security' ))
            {
                $root = CONFIG::$FGO_SANDBOX_ROOT;
                $key = "4C490B5C";
                if (get_option('wc_settings_tab_fgo_sandbox') == '0') {
                    $root = CONFIG::$FGO_ROOT;
                }
                $url = $root . 'factura/stergere';
                $data = array();

                $codUnic = get_option('wc_settings_tab_fgo_client_code');
                $privateKey = get_option('wc_settings_tab_fgo_private_key');
                $meta_invoice_number = get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) : '';
                $meta_invoice_series = get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) : '';

                $data['CodUnic'] = $codUnic;
                $data['Hash'] = strtoupper(SHA1($codUnic . $privateKey . $meta_invoice_number));
                $data['Serie'] = $meta_invoice_series;
                $data['Numar'] = $meta_invoice_number;
                $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
                $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
                $data['Versiune'] = WC()->version;
                $data['VersiuneAddon'] = CONFIG::$FGO_VERSIUNE_MODUL;
                $token = strtoupper(SHA1( $meta_invoice_series . $meta_invoice_number . $key));
                $data['Token'] = $token;

                $options = array(
                    'http' => array(
                        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                        'method'  => 'POST',
                        'content' => http_build_query($data)
                    )
                );
                $context  = stream_context_create($options);
                $result = file_get_contents($url, false, $context);
                $response = json_decode($result);

               // if ($response->{'Success'})
               // {
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_status', 'stearsa' );
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_link', '' );
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_number', '');
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_series', '');
               // }
                echo $result;
                exit;
            }
        }
    }
    
    public static function stornoInvoice(){
        function woocommerce_fgo_storno_invoice()
        {
            if (check_ajax_referer( 'fgo_field_nonce', 'security' ))
            {
                $root = CONFIG::$FGO_SANDBOX_ROOT;
                $key = "4C490B5C";
                if (get_option('wc_settings_tab_fgo_sandbox') == '0') {
                    $root = CONFIG::$FGO_ROOT;
                }
                $url = $root . 'factura/stornare';
                $data = array();

                $codUnic = get_option('wc_settings_tab_fgo_client_code');
                $privateKey = get_option('wc_settings_tab_fgo_private_key');
                $meta_invoice_number = get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) : '';
                $meta_invoice_series = get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) : '';

                $data['CodUnic'] = $codUnic;
                $data['Hash'] = strtoupper(SHA1($codUnic . $privateKey . $meta_invoice_number));
                $data['Serie'] = $meta_invoice_series;
                $data['Numar'] = $meta_invoice_number;
                $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
                $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
                $data['Versiune'] = WC()->version;
                $data['VersiuneAddon'] = CONFIG::$FGO_VERSIUNE_MODUL;
                $token = strtoupper(SHA1( $meta_invoice_series . $meta_invoice_number . $key));
                $data['Token'] = $token;

                $options = array(
                    'http' => array(
                        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                        'method'  => 'POST',
                        'content' => http_build_query($data)
                    )
                );
                $context  = stream_context_create($options);
                $result = file_get_contents($url, false, $context);
                $response = json_decode($result);

                if ($response->{'Success'})
                {
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_status', 'stornata' );
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_link', '' );
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_number', '');
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_series', '');
                }
                echo $result;
                exit;
            }
        }
    }

    public static function addAWB(){
        function woocommerce_fgo_add_awb()
        {
            if (check_ajax_referer( 'fgo_field_nonce', 'security' ))
            {
                $root = CONFIG::$FGO_SANDBOX_ROOT;
                $url = $root . 'factura/awb';
                $data = array();
                $key = "4C490B5C";

                $codUnic = get_option('wc_settings_tab_fgo_client_code');
                $privateKey = get_option('wc_settings_tab_fgo_private_key');
                $meta_invoice_number = get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_number', true ) : '';
                $meta_invoice_series = get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) ? get_post_meta( $_POST['post_id'], '_fgo_invoice_series', true ) : '';

                $data['CodUnic'] = $codUnic;
                $data['Hash'] = strtoupper(SHA1($codUnic . $privateKey . $meta_invoice_number));
                $data['Serie'] = $meta_invoice_series;
                $data['Numar'] = $meta_invoice_number;
                $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
                $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
                $data['Versiune'] = WC()->version;
                $data['VersiuneAddon'] = CONFIG::$FGO_VERSIUNE_MODUL;
                $token = strtoupper(SHA1( $meta_invoice_series . $meta_invoice_number . $key));
                $data['Token'] = $token;
                $data['AWB'] = $_POST['awb'];
               // echo $awb;

                $options = array(
                    'http' => array(
                        'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                        'method'  => 'POST',
                        'content' => http_build_query($data)
                    )
                );
                $context  = stream_context_create($options);
                $result = file_get_contents($url, false, $context);
                $response = json_decode($result);
                if ($response->{'Success'})
                {
                    update_post_meta( $_POST['post_id'], '_fgo_invoice_awb', $data['AWB']);
                }
                echo $result;
                exit;
            }
        }
    }

    public static function updateStockAfterInvoice($order){
        $listaProduseSKU = [];
        $root = CONFIG::$FGO_SANDBOX_ROOT;
        $url = $root . 'articol/GetList';
        $codUnic = get_option('wc_settings_tab_fgo_client_code');
        $privateKey = get_option('wc_settings_tab_fgo_private_key');
        $key = "4C490B5C";

        foreach ($order->get_items() as $item) {
            //sku
            $product = wc_get_product($item->get_product_id());
            $product_sku = $product->get_sku();
            if($product_sku != null)
                array_push($listaProduseSKU, $product_sku);
        }

        if(count($listaProduseSKU) > 0)
        {
            $data['CodUnic'] = $codUnic;
            $data['Hash'] = strtoupper(SHA1($codUnic . $privateKey . ''));
            $data['Platforma'] = CONFIG::$FGO_PLATFORMA;
            $data['PlatformaUrl'] = get_option('wc_settings_tab_fgo_site_url');
            $data['Versiune'] = WC()->version;
            $data['VersiuneAddon'] = CONFIG::$FGO_VERSIUNE_MODUL;
            $token = strtoupper(SHA1( $meta_invoice_series . $meta_invoice_number . $key));
            $data['Token'] = $token;
            $data['Coduri'] = $listaProduseSKU;
            $options = array(
            'http' => array(
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                'method'  => 'POST',
                'content' => http_build_query($data)
            )
            );

            $context  = stream_context_create($options);
            $result = file_get_contents($url, false, $context);
            $response = json_decode($result);

            if($response->{'Success'}){
            
                foreach($response->Result as $elem){
            
                    foreach ($order->get_items() as $item) {
                        $product_id = $item->get_product_id();
                        //sku
                        $product = wc_get_product($product_id);
                        $product_sku = $product->get_sku();
                        if($product_sku != null){
                            if($product_sku == $elem->CodConta && $elem->Stoc != null){
                                $woocmmerce_instance = new WC_Product( $product_id );
                                $new_quantity=wc_update_product_stock( $woocmmerce_instance, $elem->Stoc);
                            }
                        }
                            
                    }
                }
        
            }
        
        }
           
    }
}