<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WC_FGO_Billing{

public static function init() {

    add_filter('woocommerce_billing_fields', 'addVATFields');
    add_action('woocommerce_checkout_process', 'validate_VAT');
    add_action( 'woocommerce_checkout_update_order_meta', 'vat_checkout_field_update_order_meta' );


function addVATFields($fields)
{
    if(get_option('wc_settings_tab_fgo_client_vat') == '1' && empty(get_option('wc_settings_tab_fgo_client_vat_field'))){
        $fields['billing_cui'] = array(
            'name'  => __( 'woocommerce_fgo_billing_cui', 'woocommerce-order-billing-cui-fgo' ),
            'type' => 'text',
            'id'   => 'wc_order_billing_cui_fgo_client',
            'label'     => __('Cod Unic', 'woocommerce'),
            'placeholder'   => _x('CUI', 'placeholder', 'woocommerce')
        );
    }
    if(get_option('wc_settings_tab_fgo_client_vat') == '1' && empty(get_option('wc_settings_tab_fgo_client_nrRegCom_field'))){
        $fields['billing_nr_reg_comertului'] = array(
            'name'  => __( 'woocommerce_fgo_nr_reg_comertului', 'woocommerce-order-nr-reg-comertului-fgo' ),
            'type' => 'text',
            'id'   => 'wc_order_nr_reg_comertului_fgo_client',
            'label'     => __('Nr reg comertului', 'woocommerce'),
            'placeholder'   => _x('Nr Registrul comertului', 'placeholder', 'woocommerce'),
            'required'  => false,
        );
    }
    return $fields;
}	


function validate_VAT() {
    // Check if set, if it's not set add an error.
    if(get_option('wc_settings_tab_fgo_client_vat') == '1' && empty(get_option('wc_settings_tab_fgo_client_vat_field'))){
    if  (!empty( $_POST['billing_company']) && empty( $_POST['billing_cui'] ) )
        wc_add_notice( 'Introduceti CUI-ul.', 'error' );
    }
}


function vat_checkout_field_update_order_meta( $order_id ) {
    $vat = $_POST['billing_cui'];
    
    if(get_option('wc_settings_tab_fgo_client_vat_external') == '1'){
        $vat = $_POST['cui'];
        $nrRegCom = $_POST['nr_reg_com'];  
    }
    else{
        if(!empty(get_option('wc_settings_tab_fgo_client_vat_field'))){
            $campCUIExtern = trim(get_option('wc_settings_tab_fgo_client_vat_field'));
            $vat = $_POST[$campCUIExtern];   
        }
        $nrRegCom = $_POST['billing_nr_reg_comertului'];
        if(!empty(get_option('wc_settings_tab_fgo_client_nrRegCom_field'))){
            $campNrRegComExtern = trim(get_option('wc_settings_tab_fgo_client_nrRegCom_field'));
            $nrRegCom = $_POST[$campNrRegComExtern];   
        }   
    }
   // check_CUI($vat);
    update_post_meta( $order_id, 'woocommerce_fgo_billing_cui', sanitize_text_field($vat) );
    update_post_meta( $order_id, 'woocommerce_fgo_billing_reg', sanitize_text_field( $nrRegCom) );
}
}
}

