﻿jQuery(function ($) {
    /**
         * FGO Panel
         */

    var wc_meta_boxes_fgo_premium = {
        init: function () {
            $('#woocommerce-fgo-premium')
                .on('click', 'button.fgo_create_invoice', this.fgo_create_invoice),
                $('#woocommerce-fgo-premium')
                    .on('click', 'a.fgo_cancel_invoice', this.fgo_cancel_invoice),
                $('#woocommerce-fgo-premium')
                    .on('click', 'a.fgo_delete_invoice', this.fgo_delete_invoice)
                $('#woocommerce-fgo-premium')
                    .on('click','a.fgo_awb', this.fgo_add_awb)
        },

        fgo_create_invoice: function () {

            $('#woocommerce-fgo-premium').block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });

            var data = {
                action: 'woocommerce_fgo_create_invoice',
                post_id: woocommerce_admin_meta_boxes_fgo_premium.post_id,
                security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
            };

            $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
                .always(function () {
                    $('#woocommerce-fgo-premium').unblock();
                })
                .done(function (result, textStatus) {
                    var obj = JSON.parse(result);
                    if (obj.Success == false) {
                        var errorMsg = obj.Message;
                        if(errorMsg.toLowerCase().indexOf('not valid for idextern') != -1 || errorMsg.toLowerCase().indexOf('idextern field is required') != -1)
                            errorMsg = 'Completeaza CUI-ul clientului pt care doresti generarea facturii';
                        $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + errorMsg + '</p></div></li></ul>');
                    }
                    else if (obj.Success) {
                        $('#woocommerce-fgo-premium').find(".inside").html('<p style="border-bottom:solid 1px #eee;padding-bottom:13px;text-align:center;"><a href="' + obj.Factura.Link + '" target="_blank" class="button">Vizualizare Factura ' + obj.Factura.Serie + ' ' + obj.Factura.Numar + '</a></p>' +
                        (obj.Factura.LinkPlata ? '<p>Link plata:<input type="text" disabled value="' + obj.Factura.LinkPlata + '"><br></p>' : ""));
                    }
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    console.log("Eroare apel, parametri: ", data);
                    $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + errorThrown + '</p></div></li></ul>');
                });

            return false;
        },

        fgo_cancel_invoice: function () {
            if (confirm("Esti sigur ca vrei sa anulezi factura?") == false)
                return;

            $('#woocommerce-fgo-premium').block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });

            var data = {
                action: 'woocommerce_fgo_cancel_invoice',
                post_id: woocommerce_admin_meta_boxes_fgo_premium.post_id,
                security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
            };

            $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
                .always(function () {
                    $('#woocommerce-fgo-premium').unblock();
                })
                .done(function (response) {
                    var obj = JSON.parse(response);
                    if (obj.Success == false) {
                        $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + obj.Message + '</p></div></li></ul>');
                    }
                    else if (obj.Success) {
                        $('#woocommerce-fgo-premium').find(".inside").html('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>Factura a fost anulata.</p></div></li></ul>');
                    }                    
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    console.log("Eroare apel, parametri: ", data);
                    $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + errorThrown + '</p></div></li></ul>');
                });
        },

        fgo_delete_invoice: function () {
            if (confirm("Esti sigur ca vrei sa stergi factura?") == false)
                return;

            $('#woocommerce-fgo-premium').block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });

            var data = {
                action: 'woocommerce_fgo_delete_invoice',
                post_id: woocommerce_admin_meta_boxes_fgo_premium.post_id,
                security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
            };

            $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
                .always(function () {
                    $('#woocommerce-fgo-premium').unblock();
                })
                .done(function (response) {
                    var obj = JSON.parse(response);
                    if (obj.Success == false) {
                        $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + obj.Message + '</p></div></li></ul>');
                    }
                    else if (obj.Success) {
                        $('#woocommerce-fgo-premium').find(".inside").html('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>Factura a fost stearsa.</p></div></li></ul>');
                    }                    
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    console.log("Eroare apel, parametri: ", data);
                    $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + errorThrown + '</p></div></li></ul>');
                });
        },

        fgo_storno_invoice: function () {
            if (confirm("Esti sigur ca vrei sa stornezi factura?") == false)
                return;

            $('#woocommerce-fgo-premium').block({
                message: null,
                overlayCSS: {
                    background: '#fff',
                    opacity: 0.6
                }
            });

            var data = {
                action: 'woocommerce_fgo_storno_invoice',
                post_id: woocommerce_admin_meta_boxes_fgo_premium.post_id,
                security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
            };

            $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
                .always(function () {
                    $('#woocommerce-fgo-premium').unblock();
                })
                .done(function (response) {
                    var obj = JSON.parse(response);
                    if (obj.Success == false) {
                        $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + obj.Message + '</p></div></li></ul>');
                    }
                    else if (obj.Success) {
                        $('#woocommerce-fgo-premium').find(".inside").html('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>Factura a fost stornata.</p></div></li></ul>');
                    }                    
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    console.log("Eroare apel, parametri: ", data);
                    $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + errorThrown + '</p></div></li></ul>');
                });
        },

        fgo_add_awb: function(){
            var awb = prompt("AWB:", "");
            if(awb != null && awb != " ")
            {
                var data = {
                    action: 'woocommerce_fgo_add_awb',
                    post_id: woocommerce_admin_meta_boxes_fgo_premium.post_id,
                    security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce,
                    awb: awb
                };
    
                $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
                 .done(function (response) {
                    var obj = JSON.parse(response);
                    if (obj.Success == false) {
                        $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + obj.Message + '</p></div></li></ul>');
                    }
                    else if (obj.Success) {
                        $('#woocommerce-fgo-premium').find(".fgo_awb_existent").text(awb);
                    }                    
                    })
                 .fail(function (jqXHR, textStatus, errorThrown) {
                    console.log("Eroare apel, parametri: ", data);
                    $('#woocommerce-fgo-premium').find(".inside").prepend('<ul class="order_notes"><li class="note system-note"><div class="note_content"><p>' + errorThrown + '</p></div></li></ul>');
                 });

            }      
        }

    };

    wc_meta_boxes_fgo_premium.init();
});