jQuery(function ($) {
    $(document).on('click','.fgo_create_invoice', function(){
        var btn = $(this);
        var td = btn.closest('td');
        var row = btn.closest('tr');
        var cell = row.find('td');
        var anchor = cell.find('a');
        var id = anchor.data('order-id');


        var data = {
            action: 'woocommerce_fgo_create_invoice',
            post_id: id,
            security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
        };

        $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
                .done(function (response, textStatus) {
                    var obj = JSON.parse(response);
                    var errorMsg = obj.Message;
                    if(errorMsg.toLowerCase().indexOf('not valid for idextern') != -1 || errorMsg.toLowerCase().indexOf('idextern field is required') != -1)
                        errorMsg = 'Completeaza CUI-ul clientului pt care doresti generarea facturii';
                    if (obj.Success == false) {
                       td.html("<span>" +  errorMsg + "</span>");
                    }
                    else if (obj.Success) {
                        td.html('<center><a href="' + obj.Factura.Link + '" target="_blank" >Factura ' + obj.Factura.Serie + ' ' + obj.Factura.Numar + 
                         '</a> &nbsp;<a href="#" class="fgo_cancel_invoice">Anuleaza</a> &nbsp; <a href="#" class="fgo_delete_invoice">Sterge</a> &nbsp; <a href="#" class="fgo_storno_invoice">Storneaza</a><center>');
                    }
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    console.log("Eroare apel, parametri: ", data);
                    td.html('<center><p style="border-bottom:solid 1px #eee;text-align:center;">' + errorThrown + '</p></center>');
                });


    });


    $(document).on('click','.fgo_cancel_invoice', function(){
        if (confirm("Esti sigur ca vrei sa anulezi factura?") == false)
                return;
        var btn = $(this);
        var td = btn.closest('td');
        var row = btn.closest('tr');
        var cell = row.find('td');
        var anchor = cell.find('a');
        var id = anchor.data('order-id');

        var data = {
            action: 'woocommerce_fgo_cancel_invoice',
            post_id: id,
            security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
        };


        $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
        .done(function (response) {
            var obj = JSON.parse(response);
            if (obj.Success == false) {
                td.html("<span>" +  obj.Message + "</span>");
            }
            else if (obj.Success) {
                td.html('<center><div class="note_content"><p>Factura a fost anulata.</p></div></center>');
            }                    
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            console.log("Eroare apel, parametri: ", data);
            td.html('<center><div class="note_content"><p>' + errorThrown + '</p></div></center>');
        });
                
    });


    $(document).on('click','.fgo_delete_invoice', function(){
        if (confirm("Esti sigur ca vrei sa stergi factura?") == false)
        return;

        var btn = $(this);
        var td = btn.closest('td');
        var row = btn.closest('tr');
        var cell = row.find('td');
        var anchor = cell.find('a');
        var id = anchor.data('order-id');

        var data = {
            action: 'woocommerce_fgo_delete_invoice',
            post_id: id,
            security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
        };

        $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
        .done(function (response) {
            var obj = JSON.parse(response);
            if (obj.Success == false) {
                td.html('<center><div class="note_content"><p>' + obj.Message + '</p></div></center>');
            }
            else if (obj.Success) {
                td.html('<center><div class="note_content"><p>Factura a fost stearsa.</p></div><center>');
            }                    
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            console.log("Eroare apel, parametri: ", data);
            td.html('<center><div class="note_content"><p>' + errorThrown + '</p></div></center>');
        });
    });
    
    
    $(document).on('click','.fgo_storno_invoice', function(){
        if (confirm("Esti sigur ca vrei sa stornezi factura?") == false)
        return;

        var btn = $(this);
        var td = btn.closest('td');
        var row = btn.closest('tr');
        var cell = row.find('td');
        var anchor = cell.find('a');
        var id = anchor.data('order-id');

        var data = {
            action: 'woocommerce_fgo_storno_invoice',
            post_id: id,
            security: woocommerce_admin_meta_boxes_fgo_premium.ajax_nonce
        };

        $.post(woocommerce_admin_meta_boxes_fgo_premium.ajax_url, data)
        .done(function (response) {
            var obj = JSON.parse(response);
            if (obj.Success == false) {
                td.html('<center><div class="note_content"><p>' + obj.Message + '</p></div></center>');
            }
            else if (obj.Success) {
                td.html('<center><div class="note_content"><p>Factura a fost stornata.</p></div><center>');
            }                    
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            console.log("Eroare apel, parametri: ", data);
            td.html('<center><div class="note_content"><p>' + errorThrown + '</p></div></center>');
        });
    });
});


